<?php
/*--------------------------------------------------------------------
 ReaderInterface.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\Readers;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Exceptions\ProductDoesNotHaveAnyCombinationsException;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisIdDtoCollection;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisValuesIdPropertyValuesIdDtoCollection;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\PricePlainDto;

/**
 * Interface ReaderInterface
 * @package Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\Readers
 */
interface ReaderInterface
{
    /**
     * @param ProductId $productId
     *
     * @return CombisIdDtoCollection
     * @throws ProductDoesNotHaveAnyCombinationsException
     */
    public function availableCombisIds(ProductId $productId): CombisIdDtoCollection;
}